function datePeriodSelection(parms) {
  return {
    title: parms.title,
    name: parms.field + '_DatePeriodSelection',
    type: 'query',
    items: [
      {
        title: 'Heute',
        name: parms.field + '_Today',
        query: parms.field + '_date_range:[NOW/DAY TO NOW/DAY+1DAY]'
      },
      /**
      {
        title: 'Die letzten 7 Tage',
        name: parms.field + '_CurrentWeek',
        query: parms.field + '_date_range:[NOW/DAY-7DAY TO NOW/DAY+1DAY]'
      },
      /**/
      {
        title: 'Aktueller Monat',
        name: parms.field + '_CurrentMonth',
        query: parms.field + '_date_range:[NOW/MONTH TO NOW/MONTH+1MONTH]'
      },
      {
        title: 'Letzter Monat',
        name: parms.field + '_LastMonth',
        query: parms.field + '_date_range:[NOW/MONTH-1MONTH TO NOW/MONTH-1DAY]'
      },
      /**
      {
        title: 'Aktuelles Quartal',
        name: parms.field + '_CurrentQuarter',
        query: parms.field + '_date_range:[NOW/MONTH-2MONTH TO NOW/MONTH+1MONTH]'
      },        
      {
        title: 'Letztes Quartal',
        name: parms.field + '_LastQuarter',
        query: parms.field + '_date_range:[NOW/MONTH-3MONTH TO NOW/MONTH-1MONTH-1DAY]'
      },
     /**/
      {
        title: 'Aktuelles Jahr',
        name: parms.field + '_CurrentYear',
        query: parms.field + '_date_range:[NOW/YEAR TO NOW/YEAR+1YEAR]'
      },
      {
        title: 'Letztes Jahr',
        name: parms.field + '_LastYear',
        query: parms.field + '_date_range:[NOW/YEAR-1YEAR TO NOW/YEAR-1DAY]'
      },
      {
        title: 'Bereich (freie Eingabe)',
        name: parms.field + '_RangeSelection',
        query: '${subQuery} allfields:' + parms.field,
        subQuery: [
          {
            query: '${value}',
            queryPart: parms.field + '_date_range:[${valueFrom} TO ${valueTo}]',
            name: parms.field + '_RangeSelectionFromTo',
            type: 'range',
            titleFrom: 'von (YYYY-MM-DD)',
            titleTo: 'bis  (YYYY-MM-DD)',
            convert: 'dateString'
          }
        ]
      },
    ]
  };
}

function dateYearSelection(parms) {
  return {
    title: parms.title,
    name: parms.field + '_DateYearSelection',
    type: 'range',
    convert: 'date',
    formatDisplay: 'yyyy',
    formatSearch: 'yyyy',
    field: parms.field,
    start: 'NOW/YEAR-' + (parms.range || 12) + 'YEARS',
    end: 'NOW/YEAR-1YEAR',
    gap: '+1YEAR',
    sortOrder: 'desc'
  };
}

function dateMonthSelection(parms) {
  return {
    title: parms.title,
    name: parms.field + '_DateMonthSelection',
    type: 'range',
    convert: 'date',
    formatDisplay: 'MMM',
    formatSearch: 'MM',
    field: parms.field,
    start: 'NOW/MONTH-' + (parms.range || 12) + 'MONTH',
    end: 'NOW/MONTH-1MONTH',
    gap: '+1MONTH',
    sortOrder: 'desc'
  };
}

function amountRangeSelection(parms) {
}

function queryGroup(parms, merge) {
  return Object.assign({
    name: parms.name + '_queryGroup',
    title: parms.title,
    type: 'query',
    items: parms.items
  }, merge || {});
}

function termsGroup(parms, merge) {
  return Object.assign({
    type: 'terms',
    name: parms.field + '_termsGroup',
    title: parms.title,
    field: parms.field
  }, merge || {});
}

function queryItem(parms) {
  return {
    title: parms.title,
    name: parms.name,
    query: parms.query
  };
}

function inputItem(parms) {
  // check field type: date, double, string
  return {
    title: parms.title,
    name: parms.field + '_inputItemQuery',
    query: '* ${subQuery}',
    subQuery: [
      {
        name: parms.field + '_inputItemSubQuery',
        title: parms.input,
        query: parms.field + ':*${value}*',
        convert: 'string'
      }
    ]
  };
}

function filterConfig(parms) {
  return {

  };
}


module.exports = {
  datePeriodSelection: datePeriodSelection,
  dateYearSelection: dateYearSelection,
  dateMonthSelection: dateMonthSelection,
  amountRangeSelection: amountRangeSelection,
  queryGroup: queryGroup,
  termsGroup: termsGroup,
  queryItem: queryItem,
  inputItem: inputItem,
  filterConfig: filterConfig
};
